/**
 * Displays a configuration row and allows manipulation of it's config object.
 * 
 * Sample usage: new CentralConfigurationPluginDojo.ConfigurationRow({ config:<config object>, onChange:<callback fn when config changes> }).placeAt(<domnod>)
 * @author nl.ivojonker
 */
define([
        "dojo/_base/declare",
        "dijit/_TemplatedMixin",
        "dijit/_WidgetsInTemplateMixin",
        "dojo/text!./templates/ConfigurationRow.html",
        "dijit/_WidgetBase"
        ],
        function(declare, _TemplatedMixin, _WidgetsInTemplateMixin, template,_WidgetBase) {

	return declare("CentralConfigurationPluginDojo.ConfigurationRow", [_WidgetBase,_TemplatedMixin, _WidgetsInTemplateMixin], {
		
		/*the below are expected upon create */
		config : "object mixin-property config is required",
 
		_domValue : "domnode from template", 
		_domEvaluate : "domnode from template",
		_domExpose : "domnode from template",
			
		templateString: template,
		widgetsInTemplate: true,

		/*
		 * Called when one of the widget's form parts is changed.
		 */
		_configChanged:function(){
			this.config.value=this._domValue.getValue();
			this.config.evaluate=this._domEvaluate.checked;
			this.config.expose=this._domExpose.checked;
			
			this.onChange();
		},
		
		_showDescription : function(){
			var $this = this;
			require(["ecm/widget/dialog/ConfirmationDialog","dijit/form/SimpleTextarea"], function(ConfirmationDialog,SimpleTextarea){
				var textArea = new SimpleTextarea({
					value: $this.config.description,
					style: "width:100%;",
					rows: 10
				});
				
				var dialog= new ConfirmationDialog(
						{title:"Description/purpose of "+$this.config.key, 
							text:'',
							buttonLabel: "Save", 
							cancelButtonDefault:false,
							style:"width:80%;height:280px;",
							onExecute: function(){
								$this.config.description=textArea.value; 
								$this._configChanged();
								this.destroy();
							}}
				);
				textArea.placeAt(dialog.description);
				dialog.show();
				
			});
		},
		
		postCreate: function(){
			this._domValue.setValue(this.config.value);
			this._domEvaluate.setValue(this.config.evaluate);
			this._domExpose.setValue(this.config.expose);
		},
		
		/**
		 * Emitter to external watcher to state that this value has changed.
		 */
		onChange: function(){
			
		}
		 
	});
});
